/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.daemon;

import org.osgi.framework.BundleContext;
import org2.eclipse.php.internal.debug.core.daemon.CommunicationDaemonRegistry;
import org2.eclipse.php.internal.debug.core.daemon.ICommunicationDaemon;

public class DebugDaemon {
    private static DebugDaemon debugDaemon;
    private ICommunicationDaemon[] daemons;

    public void startDaemons(String debuggerID) {
        if (this.daemons == null) {
            this.daemons = CommunicationDaemonRegistry.getBestMatchCommunicationDaemons();
        }
        if (this.daemons != null) {
            int i = 0;
            while (i < this.daemons.length) {
                if (debuggerID == null || this.daemons[i].isDebuggerDaemon() && debuggerID.equals(this.daemons[i].getDebuggerID())) {
                    this.daemons[i].init();
                    this.daemons[i].startListen();
                }
                ++i;
            }
        }
    }

    public void stopDaemons(String debuggerID) {
        if (this.daemons != null) {
            int i = 0;
            while (i < this.daemons.length) {
                if (debuggerID == null || this.daemons[i].isDebuggerDaemon() && debuggerID.equals(this.daemons[i].getDebuggerID())) {
                    this.daemons[i].stopListen();
                }
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        debugDaemon = null;
        this.stopDaemons(null);
        this.daemons = null;
    }

    public boolean validateCommunicationDaemons(String debuggerID) {
        boolean validated = true;
        if (this.daemons != null) {
            int i = 0;
            while (i < this.daemons.length) {
                if ((debuggerID == null || this.daemons[i].isDebuggerDaemon() && debuggerID.equals(this.daemons[i].getDebuggerID())) && !this.daemons[i].isListening()) {
                    validated &= this.daemons[i].resetSocket();
                }
                ++i;
            }
        }
        return validated;
    }

    public static DebugDaemon getDefault() {
        if (debugDaemon == null) {
            debugDaemon = new DebugDaemon();
        }
        return debugDaemon;
    }
}

